@echo off
REM MicroCat.1 へのファイルアップロードスクリプト（Windows用）
REM 使用方法: upload.bat [COMポート番号] [ファイル名]
REM 例: upload.bat COM3 led_blink.py

set PORT=%1
set FILE=%2

if "%PORT%"=="" (
    echo 使用方法: upload.bat [COMポート番号] [ファイル名]
    echo 例: upload.bat COM3 led_blink.py
    echo.
    echo COMポート番号を自動検出する場合は、mpremote を使用してください:
    echo   mpremote cp led_blink.py :led_blink.py
    exit /b 1
)

if "%FILE%"=="" (
    set FILE=led_blink.py
)

echo MicroCat.1 に %FILE% をアップロード中...
echo COMポート: %PORT%

REM mpremote がインストールされているか確認
where mpremote >nul 2>&1
if %errorlevel% neq 0 (
    echo mpremote がインストールされていません。
    echo インストール: pip install mpremote
    exit /b 1
)

mpremote connect %PORT% cp %FILE% :%FILE%

if %errorlevel% equ 0 (
    echo.
    echo アップロード成功！
    echo ファイルを実行するには、ターミナルで以下を実行:
    echo   exec(open('%FILE%').read())
) else (
    echo.
    echo アップロード失敗。COMポート番号とファイル名を確認してください。
)

