"""
MicroCat.1 用 LED 点滅プログラム
LED1 (GPIO25, 緑色) と LED2 (GPIO29, 青色) を交互に点滅させます
"""

from machine import Pin
import time

# LED のピン設定
LED1_PIN = 25  # ユーザーLED（緑色）
LED2_PIN = 29  # インジケータLED（青色）

# LED オブジェクトの作成（出力モード）
led1 = Pin(LED1_PIN, Pin.OUT)
led2 = Pin(LED2_PIN, Pin.OUT)

def blink_leds(interval=0.5, count=None):
    """
    2つのLEDを交互に点滅させる
    
    Args:
        interval: 点滅間隔（秒）
        count: 点滅回数（Noneの場合は無限ループ）
    """
    iteration = 0
    
    try:
        while count is None or iteration < count:
            # LED1を点灯、LED2を消灯
            led1.on()
            led2.off()
            time.sleep(interval)
            
            # LED1を消灯、LED2を点灯
            led1.off()
            led2.on()
            time.sleep(interval)
            
            iteration += 1
            
    except KeyboardInterrupt:
        # Ctrl+C で停止した場合、両方のLEDを消灯
        led1.off()
        led2.off()
        print("\nプログラムを停止しました")

if __name__ == "__main__":
    print("LED点滅プログラムを開始します")
    print("LED1 (GPIO25, 緑色) と LED2 (GPIO29, 青色) を交互に点滅させます")
    print("停止するには Ctrl+C を押してください")
    
    # 無限ループで点滅（0.5秒間隔）
    blink_leds(interval=0.5)

