#!/bin/bash
# MicroCat.1 へのファイルアップロードスクリプト（Mac/Linux用）
# 使用方法: ./upload.sh [デバイスパス] [ファイル名]
# 例: ./upload.sh /dev/ttyUSB0 led_blink.py

PORT=${1:-/dev/ttyUSB0}
FILE=${2:-led_blink.py}

echo "MicroCat.1 に $FILE をアップロード中..."
echo "デバイス: $PORT"

# mpremote がインストールされているか確認
if ! command -v mpremote &> /dev/null; then
    echo "mpremote がインストールされていません。"
    echo "インストール: pip install mpremote"
    exit 1
fi

# デバイスが存在するか確認
if [ ! -e "$PORT" ]; then
    echo "エラー: デバイス $PORT が見つかりません。"
    echo "利用可能なデバイスを確認してください:"
    ls -la /dev/tty*USB* /dev/tty*ACM* 2>/dev/null || echo "  デバイスが見つかりません"
    exit 1
fi

mpremote connect "$PORT" cp "$FILE" :"$FILE"

if [ $? -eq 0 ]; then
    echo ""
    echo "アップロード成功！"
    echo "ファイルを実行するには、ターミナルで以下を実行:"
    echo "  exec(open('$FILE').read())"
else
    echo ""
    echo "アップロード失敗。デバイスパスとファイル名を確認してください。"
    exit 1
fi

