# ADT7410 温度センサーの接続と使用方法

ADT7410は16ビット高精度デジタル温度センサーです。I2CインターフェースでMicroCat.1に接続して温度を取得できます。

## 必要な部品

- ADT7410 温度センサー
- プルアップ抵抗: 4.7kΩ～10kΩ × 2本（SDA、SCL用）
- ジャンパーワイヤー（必要に応じて）

## ハードウェア接続

### 1. 電源接続

ADT7410の電源ピン（VDD）をMicroCat.1の3.3Vまたは5Vに接続します。
- **VDD**: MicroCat.1の3.3Vまたは5V
- **GND**: MicroCat.1のGND

**注意**: ADT7410の動作電圧範囲は2.7V～5.5Vです。MicroCat.1のI2Cバス電圧（通常3.3V）に合わせて電源を選択してください。

### 2. I2C接続

MicroCat.1のI2C0バスを使用します：

| ADT7410 | MicroCat.1 | 説明 |
|---------|------------|------|
| SDA | GPIO4 | データライン |
| SCL | GPIO5 | クロックライン |
| VDD | 3.3V または 5V | 電源 |
| GND | GND | グラウンド |

### 3. プルアップ抵抗

I2Cバスにはプルアップ抵抗が必要です：
- **SDA（GPIO4）**: 4.7kΩ～10kΩの抵抗で3.3Vに接続
- **SCL（GPIO5）**: 4.7kΩ～10kΩの抵抗で3.3Vに接続

**注意**: 一部のMicroCat.1基板にはプルアップ抵抗が内蔵されている場合があります。その場合は追加の抵抗は不要です。

### 4. I2Cアドレスの設定（オプション）

ADT7410のデフォルトI2Cアドレスは **0x48** です。
A0、A1ピンをGNDまたはVDDに接続することで、アドレスを変更できます：

| A1 | A0 | I2Cアドレス |
|----|----|-------------|
| GND | GND | 0x48（デフォルト） |
| GND | VDD | 0x49 |
| VDD | GND | 0x4A |
| VDD | VDD | 0x4B |

## ソフトウェアのセットアップ

### 1. ファイルのアップロード

以下の2つのファイルをMicroCat.1にアップロードします：

```bash
# mpremote を使用する場合
mpremote cp adt7410.py :adt7410.py
mpremote cp temperature_read.py :temperature_read.py

# または、アップロードスクリプトを使用
.\upload.ps1 COM7 adt7410.py
.\upload.ps1 COM7 temperature_read.py
```

### 2. プログラムの実行

ターミナルエミュレータで以下のコマンドを実行：

```python
>>> exec(open('temperature_read.py').read())
```

または、`main.py`として保存して自動実行：

```bash
mpremote cp temperature_read.py :main.py
```

その後、リセットボタン（SW1）を押すと自動的に温度読み取りが開始されます。

## プログラムのカスタマイズ

### 読み取り間隔の変更

`temperature_read.py`の`read_temperature_continuous()`関数の`interval`パラメータを変更：

```python
# 5秒間隔で読み取り
read_temperature_continuous(interval=5.0)
```

### I2Cアドレスの変更

ADT7410のアドレスが0x48以外の場合、`temperature_read.py`の`ADT7410_ADDRESS`を変更：

```python
# アドレスが0x49の場合
ADT7410_ADDRESS = 0x49
```

### 1回だけ温度を読み取る

```python
>>> from temperature_read import read_temperature_once
>>> temp = read_temperature_once()
温度: 25.30°C (77.54°F)
```

## トラブルシューティング

### ADT7410が見つからない

1. **I2C接続を確認**
   - SDA（GPIO4）とSCL（GPIO5）の接続を確認
   - 配線の断線や接触不良がないか確認

2. **プルアップ抵抗を確認**
   - SDAとSCLにプルアップ抵抗（4.7kΩ～10kΩ）が接続されているか確認
   - 抵抗値が適切か確認（小さすぎると電流が流れすぎ、大きすぎると信号が不安定）

3. **電源を確認**
   - ADT7410のVDDに電源（3.3Vまたは5V）が供給されているか確認
   - GNDが正しく接続されているか確認

4. **I2Cアドレスを確認**
   - デフォルトアドレス（0x48）以外を使用している場合、`temperature_read.py`の`ADT7410_ADDRESS`を変更
   - ターミナルでI2Cスキャンを実行して確認：
     ```python
     >>> from machine import I2C, Pin
     >>> i2c = I2C(0, sda=Pin(4), scl=Pin(5), freq=100000)
     >>> i2c.scan()
     [72]  # 0x48が検出された場合
     ```

### 温度が正しく読み取れない

1. **初期化待機時間を確認**
   - ADT7410の初期化には最大240msかかります
   - プログラム実行直後に読み取る場合は、十分な待機時間を確保

2. **I2C通信速度を確認**
   - デフォルトは100kHz（標準速度）
   - 通信エラーが発生する場合は、より低い周波数（50kHzなど）を試す

3. **配線の長さを確認**
   - I2Cバスの配線が長すぎると通信が不安定になります
   - 可能な限り短い配線を使用

## ADT7410の仕様

- **測定範囲**: -55℃～+150℃
- **精度**: ±0.5℃（-10℃～+85℃）
- **分解能**: 0.0078℃（16ビットモード）
- **I2Cアドレス**: 0x48（デフォルト、A0/A1で変更可能）
- **動作電圧**: 2.7V～5.5V
- **消費電流**: 約700μA（連続測定モード）

## 参考資料

- MicroCat.1 Wiki: https://github.com/mechatrax/microcat1/wiki
- MicroPython ドキュメント: https://docs.micropython.org/
- Raspberry Pi Pico 2 ドキュメント: https://www.raspberrypi.com/documentation/microcontrollers/
- ADT7410 データシート: https://www.analog.com/media/en/technical-documentation/data-sheets/ADT7410.pdf

